IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_ROUND_ABNT]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

DROP FUNCTION [dbo].[UFD_ROUND_ABNT]

---select dbo.UFD_ROUND_ABNT(0.3050), ROUND(0.3050, 2)
GO
CREATE FUNCTION dbo.UFD_ROUND_ABNT (
    @Valor NUMERIC(38, 16)
)
RETURNS NUMERIC(38, 16)
AS
BEGIN
 
    DECLARE
        @Parte_Inteira INT = ROUND(@Valor, 0, 1),
        @Parte_Decimal NUMERIC(38, 16) = @Valor - ROUND(@Valor, 0, 1),
        @Nova_Parte_Decimal NUMERIC(38, 16),
        @SegundoDecimal INT,
        @DoisPrimeirosDecimais AS NUMERIC(18, 2),
        @RestanteDosDecimais AS NUMERIC(38, 16)
 
 
    
    SELECT
        @SegundoDecimal = (@Parte_Decimal * 100)%10,
        @DoisPrimeirosDecimais = ROUND(@Parte_Decimal/.01, 0, 1)/100,
        @RestanteDosDecimais = (@Parte_Decimal - @DoisPrimeirosDecimais)*100
    
    SELECT
        @Nova_Parte_Decimal = (CASE
            WHEN @RestanteDosDecimais > 0.5 THEN @DoisPrimeirosDecimais + 0.01
            WHEN @RestanteDosDecimais < 0.5 THEN @DoisPrimeirosDecimais
            ELSE @DoisPrimeirosDecimais + IIF(@SegundoDecimal % 2 = 0, 0.00, 0.01)
        END)
 
   
    RETURN (@Parte_Inteira + @Nova_Parte_Decimal)
 
 
END